<?php
class ControllerExtensionPaymentMykassa extends Controller
{	
	public function index() 
	{
		$data['button_confirm'] = $this->language->get('button_confirm');
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		$data['lang'] = $this->session->data['language'];
		$data['action'] = $this->config->get('mykassa_url');
		$data['m_shop'] = $this->config->get('mykassa_merchant');
		$data['m_orderid'] = $this->session->data['order_id'];
		$data['m_amount'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
		$m_curr = strtoupper($order_info['currency_code']);
		$data['m_curr'] = ($m_curr == 'RUR') ? 'RUB' : $m_curr;
		$data['m_desc'] = base64_encode($order_info['comment']);

		$arHash = array(
			$data['m_shop'],
			$data['m_amount'],
            $this->config->get('mykassa_security1'),
			$data['m_orderid']
		);
		
		$data['sign'] = md5( implode(':', $arHash));
		
		$this->model_checkout_order->addOrderHistory($data['m_orderid'], $this->config->get('mykassa_order_wait_id'));
		
		return $this->load->view('extension/payment/mykassa', $data);
	}

	public function status()
	{
		$request = $this->request->request;
		
		if (isset($request["intid"]) && isset($request["SIGN"]))
		{
			$err = false;
			$message = '';
			$this->load->language('extension/payment/mykassa');
		
			// запись логов

            $log_text =
                "--------------------------------------------------------\n" .
                "shop               " . $request['MERCHANT_ID'] . "\n" .
                "amount             " . $request['AMOUNT'] . "\n" .
                "operation id       " . $request['intid'] . "\n" .
                "order id           " . $request['MERCHANT_ORDER_ID'] . "\n" .
                "e-mail client      " . $request['P_EMAIL'] . "\n" .
                "phone ckient       " . $request['P_PHONE'] . "\n" .
                "currency           " . $request['CUR_ID'] . "\n" .
                "sign               " . $request['SIGN'] . "\n\n";
			
			$log_file = $this->config->get('mykassa_log_value');
			
			if (!empty($log_file))
			{
				file_put_contents($_SERVER['DOCUMENT_ROOT'] . $log_file, $log_text, FILE_APPEND);
			}

			// проверка цифровой подписи и ip

			$sign_hash = md5( implode(":", array(
				$request['MERCHANT_ID'],
                $this->config->get('mykassa_security2'),
				$request['AMOUNT'],
				$request['MERCHANT_ORDER_ID']
			)));

			$sIP = str_replace(' ', '', $this->config->get('mykassa_list_ip'));
            $valid_ip = true;
            if ( ! empty( $sIP ) ) {

                $ip_filter_arr = explode(',', $sIP);
                $this_ip  = (isset($_SERVER['HTTP_X_REAL_IP'])) ? $_SERVER['HTTP_X_REAL_IP'] : $_SERVER['REMOTE_ADDR'];

                foreach ( $ip_filter_arr as $key => $value ) {
                    $ip_filter_arr[ $key ] = ip2long( $value );
                }

                if ( ! in_array( ip2long($this_ip), $ip_filter_arr)) {
                    $valid_ip = false;
                }

            }
			
			if (!$valid_ip)
			{
				$message .= $this->language->get('text_email_message4') . "\n" . 
				$this->language->get('text_email_message5') . $sIP . "\n" . 
				$this->language->get('text_email_message6') . $_SERVER['REMOTE_ADDR'] . "\n";
				$err = true;
			}

            if (!$err)
			{
				// загрузка заказа
				
				$this->load->model('checkout/order');
				$order = $this->model_checkout_order->getOrder($request['MERCHANT_ORDER_ID']);
				
				if (!$order)
				{
					$message .= $this->language->get('text_email_message9') . "\n";
					$err = true;
				}
				else
				{
					$order_curr = ($order['currency_code'] == 'RUR') ? 'RUB' : $order['currency_code'];
					$order_amount = number_format($order['total'], 2, '.', '');
					
					// проверка суммы
				
					if ($request['AMOUNT'] != $order_amount)
					{
						$message .= $this->language->get('text_email_message7') . "\n";
						$err = true;
					}

					// проверка статуса
					
					if (!$err)
					{
						if ($request['SIGN'] != $sign_hash) {

                            if ($order['order_status_id'] !== $this->config->get('mykassa_order_success_id')) {
                                $this->model_checkout_order->addOrderHistory($request['MERCHANT_ORDER_ID'], $this->config->get('mykassa_order_success_id'));
                                echo 'YES';
                            }
                        }else{
							
                            if ($order['order_status_id'] !== $this->config->get('mykassa_order_fail_id')) {

                                $message .= $this->language->get('text_email_message2') . "\n";
                                $this->model_checkout_order->addOrderHistory($request['MERCHANT_ORDER_ID'], $this->config->get('mykassa_order_fail_id'));
                                $err = true;
                            }
						}
					}
				}
			}
			
			if ($err)
			{
				$to = $this->config->get('mykassa_admin_email');

				if (!empty($to))
				{
					$message = $this->language->get('text_email_message1') . "\n\n" . $message . "\n" . $log_text;
					$headers = "From: no-reply@" . $_SERVER['HTTP_HOST'] . "\r\n" . 
					"Content-type: text/plain; charset=utf-8 \r\n";
					mail($to, $this->language->get('text_email_subject'), $message, $headers);
				}
				
				echo $request['MERCHANT_ORDER_ID'] . '| error |' . $message;
			}
		}
   	}

	public function fail() 
	{
		$this->response->redirect($this->url->link('checkout/checkout'));	
		return true;
	}

	public function success() 
	{
		$this->response->redirect($this->url->link('checkout/success'));
		return true;
	}
}